"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newlineAndContinue = newlineAndContinue;
exports.newLine = newLine;

var CodeMirror = _interopRequireWildcard(require("codemirror"));

var _repeatString = _interopRequireDefault(require("repeat-string"));

var _table = require("./table");

var _utils = require("./utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// HyperMD, copyright (c) by laobubu
// Distributed under an MIT license: http://laobubu.net/HyperMD/LICENSE
//
// powerful keymap for HyperMD and Markdown modes
//

/**
  Some codes in this files are from CodeMirror's source code.
  CodeMirror, copyright (c) by Marijn Haverbeke and others
  MIT license: http://codemirror.net/LICENSE
  @see codemirror\addon\edit\continuelist.js
 */
// loq = List Or Quote
const listOrQuoteRE = /^(\s*)(>[> ]*|[*+-] \[[x ]\]\s|[*+-]\s|(\d+)([.)]))(\s*)/;
const emptylistOrQuoteRE = /^(\s*)(>[> ]*|[*+-] \[[x ]\]|[*+-]|(\d+)[.)])(\s*)$/;
const unorderedListRE = /[*+-]\s/;
/**
 * continue list / quote / insert table row
 * start a table
 */

function newlineAndContinue(cm) {
  const enableTableHelpers = cm.getOption('tableHelpers');
  if (cm.getOption('disableInput')) return CodeMirror.Pass;
  const selections = cm.listSelections();
  var replacements = [];

  for (const range of selections) {
    var pos = range.head;
    const rangeEmpty = range.empty();
    const eolState = (0, _utils.getGfmState)(cm.getStateAfter(pos.line));
    const line = cm.getLine(pos.line);
    let handled = false;

    if (!handled) {
      const inList = eolState.list !== false;
      const inQuote = eolState.quote;
      const match = listOrQuoteRE.exec(line);
      const cursorBeforeBullet = /^\s*$/.test(line.slice(0, pos.ch));

      if (rangeEmpty && (inList || inQuote) && match && !cursorBeforeBullet) {
        handled = true;

        if (emptylistOrQuoteRE.test(line)) {
          if (!/>\s*$/.test(line)) cm.replaceRange('', {
            line: pos.line,
            ch: 0
          }, {
            line: pos.line,
            ch: pos.ch + 1
          });
          replacements.push('\n');
        } else {
          var indent = match[1],
              after = match[5];
          var numbered = !(unorderedListRE.test(match[2]) || match[2].indexOf('>') >= 0);
          var bullet = numbered ? parseInt(match[3], 10) + 1 + match[4] : match[2].replace('x', ' ');
          replacements.push('\n' + indent + bullet + after);
          if (numbered) incrementRemainingMarkdownListNumbers(cm, pos);
        }
      }
    }

    if (enableTableHelpers && !handled && (0, _table.newTableRowAndContinue)(cm, range)) {
      return;
    }

    if (!handled) {
      if (rangeEmpty && line.slice(pos.ch - 2, pos.ch) == '$$' && /math-end/.test(cm.getTokenTypeAt(pos))) {
        // ignore indentations of MathBlock Tex lines
        replacements.push('\n');
        handled = true;
      }
    }

    if (!handled) {
      cm.execCommand('newlineAndIndent');
      return;
    }
  }

  cm.replaceSelections(replacements);
}
/** insert "\n" , or if in list, insert "\n" + indentation */


function newLine(cm) {
  if (cm.getOption('disableInput')) return CodeMirror.Pass;
  const selections = cm.listSelections();
  var replacements = (0, _repeatString.default)('\n', selections.length);

  for (let i = 0; i < selections.length; i++) {
    var range = selections[i];
    var pos = range.head;
    const eolState = (0, _utils.getGfmState)(cm.getStateAfter(pos.line));

    if (eolState.list !== false) {
      replacements[i] += (0, _repeatString.default)(' ', eolState.listStack.slice(-1)[0]);
    }
  }

  cm.replaceSelections(replacements);
} // Auto-updating Markdown list numbers when a new item is added to the
// middle of a list


function incrementRemainingMarkdownListNumbers(cm, pos) {
  const listRE = listOrQuoteRE;
  var startLine = pos.line,
      lookAhead = 0,
      skipCount = 0;
  var startItem = listRE.exec(cm.getLine(startLine)),
      startIndent = startItem[1];

  do {
    lookAhead += 1;
    var nextLineNumber = startLine + lookAhead;
    var nextLine = cm.getLine(nextLineNumber),
        nextItem = listRE.exec(nextLine);

    if (nextItem) {
      var nextIndent = nextItem[1];
      var newNumber = parseInt(startItem[3], 10) + lookAhead - skipCount;
      var nextNumber = parseInt(nextItem[3], 10),
          itemNumber = nextNumber;

      if (startIndent === nextIndent && !isNaN(nextNumber)) {
        if (newNumber === nextNumber) itemNumber = nextNumber + 1;
        if (newNumber > nextNumber) itemNumber = newNumber + 1;
        cm.replaceRange(nextLine.replace(listRE, nextIndent + itemNumber + nextItem[4] + nextItem[5]), {
          line: nextLineNumber,
          ch: 0
        }, {
          line: nextLineNumber,
          ch: nextLine.length
        });
      } else {
        if (startIndent.length > nextIndent.length) return; // This doesn't run if the next line immediatley indents, as it is
        // not clear of the users intention (new indented item or same level)

        if (startIndent.length < nextIndent.length && lookAhead === 1) return;
        skipCount += 1;
      }
    }
  } while (nextItem);
}

Object.assign(CodeMirror.commands, {
  enhancedNewlineAndContinue: newlineAndContinue,
  enhancedNewline: newLine
});