"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shiftTab = shiftTab;
exports.tab = tab;

var CodeMirror = _interopRequireWildcard(require("codemirror"));

var _repeatString = _interopRequireDefault(require("repeat-string"));

var _table = require("./table");

var _utils = require("./utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// HyperMD, copyright (c) by laobubu
// Distributed under an MIT license: http://laobubu.net/HyperMD/LICENSE
//
// powerful keymap for HyperMD and Markdown modes
//
const ListRE = /^(\s*)([*+-]\s|(\d+)([.)]))(\s*)/;

function getLineSafely(cm, lineNo) {
  return cm.getLine(lineNo).replace(/\u00A0/g, ' ');
}

function killIndent(cm, lineNo, spaces) {
  if (!spaces || spaces < 0) return;
  const oldSpaces = /^ */.exec(getLineSafely(cm, lineNo))[0].length;
  if (oldSpaces < spaces) spaces = oldSpaces;
  if (spaces > 0) cm.replaceRange('', {
    line: lineNo,
    ch: 0
  }, {
    line: lineNo,
    ch: spaces
  });
}
/** unindent or move cursor into prev table cell */


function shiftTab(cm) {
  const enableTableHelpers = cm.getOption('tableHelpers');
  var selections = cm.listSelections();

  for (let i = 0; i < selections.length; i++) {
    var range = selections[i];
    var left = range.head;
    var right = range.anchor;
    const rangeEmpty = range.empty();
    if (!rangeEmpty && (0, CodeMirror.cmpPos)(left, right) > 0) [right, left] = [left, right];else if (right === left) {
      right = range.anchor = {
        ch: left.ch,
        line: left.line
      };
    }

    if (enableTableHelpers) {
      const sel = (0, _table.moveToPreviousTableCell)(cm, range);

      if (sel) {
        cm.setSelection(sel.anchor, sel.head);
        return;
      }
    }

    const eolState = (0, _utils.getGfmState)(cm.getStateAfter(left.line));

    if (eolState.listStack.length > 0) {
      let lineNo = left.line;

      while (!ListRE.test(getLineSafely(cm, lineNo))) {
        // beginning line has no bullet? go up
        lineNo--;
        const isList = (0, _utils.getGfmState)(cm.getStateAfter(lineNo)).listStack.length > 0;

        if (!isList) {
          lineNo++;
          break;
        }
      }

      const lastLine = cm.lastLine();
      let tmp;

      for (; lineNo <= right.line && (tmp = ListRE.exec(getLineSafely(cm, lineNo))); lineNo++) {
        const listStack = (0, _utils.getGfmState)(cm.getStateAfter(lineNo)).listStack;
        const listLevel = listStack.length;
        let spaces = 0;

        if (listLevel == 1) {
          // maybe user wants to trimLeft?
          spaces = tmp[1].length;
        } else {
          // make bullets right-aligned
          spaces = listStack[listLevel - 1] - (listStack[listLevel - 2] || 0);
        }

        killIndent(cm, lineNo, spaces); // if current list item is multi-line...

        while (++lineNo <= lastLine) {
          if (
          /*corrupted */
          (0, _utils.getGfmState)(cm.getStateAfter(lineNo)).listStack.length !== listLevel) {
            lineNo = Infinity;
            break;
          }

          if (
          /*has bullet*/
          ListRE.test(getLineSafely(cm, lineNo))) {
            lineNo--;
            break;
          }

          killIndent(cm, lineNo, spaces);
        }
      }

      return;
    }
  }

  cm.execCommand('indentLess');
}
/**
 * 1. for tables, move cursor into next table cell, and maybe insert a cell
 * 2.
 */


function tab(cm) {
  const enableTableHelpers = cm.getOption('tableHelpers');
  var selections = [...cm.listSelections()];
  var beforeCur = [];
  var afterCur = [];
  var addIndentTo = {}; // {lineNo: stringIndent}

  /** indicate previous 4 variable changed or not */

  var flag0 = false,
      flag1 = false,
      flag2 = false;

  function setBeforeCur(i, text) {
    beforeCur[i] = text;
    if (text) flag1 = true;
  }

  function setAfterCur(i, text) {
    afterCur[i] = text;
    if (text) flag2 = true;
  }

  for (let i = 0; i < selections.length; i++) {
    beforeCur[i] = afterCur[i] = '';
    var range = selections[i];
    var left = Object.assign({}, range.head);
    var right = Object.assign({}, range.anchor);
    const rangeEmpty = range.empty();
    if (!rangeEmpty && (0, CodeMirror.cmpPos)(left, right) > 0) [right, left] = [left, right];else if (right === left) {
      right = range.anchor = {
        ch: left.ch,
        line: left.line
      };
    }
    const eolState = (0, _utils.getGfmState)(cm.getStateAfter(left.line));

    if (eolState.table && enableTableHelpers) {
      // yeah, we are inside a table
      flag0 = true; // cursor will move

      const result = (0, _table.moveToNextTableCell)(cm, range);
      result.beforeCur && setBeforeCur(i, result.beforeCur);
      result.afterCur && setAfterCur(i, result.afterCur);

      if (result.moveTo) {
        selections[i] = result.moveTo;
      }
    } else if (eolState.listStack.length > 0) {
      // add indent to current line
      let lineNo = left.line;
      let tmp; // ["  * ", "  ", "* "]

      while (!(tmp = ListRE.exec(getLineSafely(cm, lineNo)))) {
        // beginning line has no bullet? go up
        lineNo--;
        const isList = (0, _utils.getGfmState)(cm.getStateAfter(lineNo)).listStack.length > 0;

        if (!isList) {
          lineNo++;
          break;
        }
      }

      const firstLine = cm.firstLine();
      const lastLine = cm.lastLine();

      for (; lineNo <= right.line && (tmp = ListRE.exec(getLineSafely(cm, lineNo))); lineNo++) {
        const eolState = (0, _utils.getGfmState)(cm.getStateAfter(lineNo));
        const listStack = eolState.listStack;
        const listStackOfPrevLine = (0, _utils.getGfmState)(cm.getStateAfter(lineNo - 1)).listStack;
        const listLevel = listStack.length;
        let spaces = ''; // avoid uncontinuous list levels

        if (lineNo > firstLine && listLevel <= listStackOfPrevLine.length) {
          if (listLevel == listStackOfPrevLine.length) {
            // tmp[1] is existed leading spaces
            // listStackOfPrevLine[listLevel-1] is desired indentation
            spaces = (0, _repeatString.default)(' ', listStackOfPrevLine[listLevel - 1] - tmp[1].length);
          } else {
            // make bullets right-aligned
            // tmp[0].length is end pos of current bullet
            spaces = (0, _repeatString.default)(' ', listStackOfPrevLine[listLevel] - tmp[0].length);
          }
        }

        addIndentTo[lineNo] = spaces; // if current list item is multi-line...

        while (++lineNo <= lastLine) {
          if (
          /*corrupted */
          (0, _utils.getGfmState)(cm.getStateAfter(lineNo)).listStack.length !== listLevel) {
            lineNo = Infinity;
            break;
          }

          if (
          /*has bullet*/
          ListRE.test(getLineSafely(cm, lineNo))) {
            lineNo--;
            break;
          }

          addIndentTo[lineNo] = spaces;
        }
      }

      if (!rangeEmpty) break;
    } else {
      cm.execCommand('indentMore');
    }
  }

  cm.operation(() => {
    // if (!(flag0 || flag1 || flag2)) return cm.execCommand("defaultTab")
    // console.log(flag0, flag1, flag2)
    for (const lineNo in addIndentTo) {
      if (addIndentTo[lineNo]) cm.replaceRange(addIndentTo[lineNo], {
        line: ~~lineNo,
        ch: 0
      });
    }

    if (flag0) cm.setSelections(selections);
    if (flag1) cm.replaceSelections(beforeCur);
    if (flag2) cm.replaceSelections(afterCur, 'start');
  });
}

Object.assign(CodeMirror.commands, {
  enhancedShiftTab: shiftTab,
  enhancedTab: tab
});