import CodeMirror from 'codemirror/lib/codemirror'
import { getGfmState } from './utils'
import { moveToNextTableCell, moveToPreviousTableCell } from './table'

export function tabAndIndentMarkdownList(cm) {
  const enableTableHelpers = cm.getOption('tableHelpers')
  const ranges = cm.listSelections()
  const range = ranges[0]
  const pos = range.head
  const eolState = getGfmState(cm.getStateAfter(pos.line))

  if (eolState.table && enableTableHelpers) {
    const result = moveToNextTableCell(cm, range)
    if (result.moveTo) {
      const { moveTo } = result
      cm.setSelection(moveTo.anchor, moveTo.head)
    }
    return
  }

  cm.execCommand('indentMore')
}

export function shiftTabAndUnindentMarkdownList(cm) {
  const enableTableHelpers = cm.getOption('tableHelpers')
  const ranges = cm.listSelections()
  const pos = ranges[0].head
  const eolState = getGfmState(cm.getStateAfter(pos.line))

  if (eolState.table && enableTableHelpers) {
    const range = ranges[0]
    const moveTo = moveToPreviousTableCell(cm, range)
    if (moveTo) {
      cm.setSelection(moveTo.anchor, moveTo.head)
    }
    return
  }

  cm.execCommand('indentLess')
}

Object.assign(CodeMirror.commands, {
  tabAndIndentMarkdownList,
  shiftTabAndUnindentMarkdownList
})
