import * as CodeMirror from 'codemirror'

CodeMirror.defineOption('watchComposition', false, function (
  cm,
  newVal,
  _oldVal
) {
  if (newVal) {
    if (window.CompositionEvent != null) {
      return initCompositionMode(cm)
    } else {
      console.warn("Your browser doesn't support CompositionEvent.")
      return cm.setOption('watchComposition', false)
    }
  }
})

function initCompositionMode(cm) {
  const inputField = cm.getInputField()

  CodeMirror.on(inputField, 'compositionstart', function (_event) {
    if (!cm.options.watchComposition) return
    cm.display.inCompositionMode = true

    inputField.classList.add('cm-in-composition')
  })

  CodeMirror.on(inputField, 'compositionend', function (_event) {
    if (!cm.options.watchComposition) return
    inputField.classList.remove('cm-in-composition')

    cm.display.inCompositionMode = false
  })
}
