"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tabAndIndentMarkdownList = tabAndIndentMarkdownList;
exports.shiftTabAndUnindentMarkdownList = shiftTabAndUnindentMarkdownList;

var _codemirror = _interopRequireDefault(require("codemirror/lib/codemirror"));

var _utils = require("./utils");

var _table = require("./table");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function tabAndIndentMarkdownList(cm) {
  const enableTableHelpers = cm.getOption('tableHelpers');
  const ranges = cm.listSelections();
  const range = ranges[0];
  const pos = range.head;
  const eolState = (0, _utils.getGfmState)(cm.getStateAfter(pos.line));

  if (eolState.table && enableTableHelpers) {
    const result = (0, _table.moveToNextTableCell)(cm, range);

    if (result.moveTo) {
      const {
        moveTo
      } = result;
      cm.setSelection(moveTo.anchor, moveTo.head);
    }

    return;
  }

  cm.execCommand('indentMore');
}

function shiftTabAndUnindentMarkdownList(cm) {
  const enableTableHelpers = cm.getOption('tableHelpers');
  const ranges = cm.listSelections();
  const pos = ranges[0].head;
  const eolState = (0, _utils.getGfmState)(cm.getStateAfter(pos.line));

  if (eolState.table && enableTableHelpers) {
    const range = ranges[0];
    const moveTo = (0, _table.moveToPreviousTableCell)(cm, range);

    if (moveTo) {
      cm.setSelection(moveTo.anchor, moveTo.head);
    }

    return;
  }

  cm.execCommand('indentLess');
}

Object.assign(_codemirror.default.commands, {
  tabAndIndentMarkdownList,
  shiftTabAndUnindentMarkdownList
});