"use strict";

var CodeMirror = _interopRequireWildcard(require("codemirror"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

CodeMirror.defineOption('watchComposition', false, function (cm, newVal, _oldVal) {
  if (newVal) {
    if (window.CompositionEvent != null) {
      return initCompositionMode(cm);
    } else {
      console.warn("Your browser doesn't support CompositionEvent.");
      return cm.setOption('watchComposition', false);
    }
  }
});

function initCompositionMode(cm) {
  const inputField = cm.getInputField();
  CodeMirror.on(inputField, 'compositionstart', function (_event) {
    if (!cm.options.watchComposition) return;
    cm.display.inCompositionMode = true;
    inputField.classList.add('cm-in-composition');
  });
  CodeMirror.on(inputField, 'compositionend', function (_event) {
    if (!cm.options.watchComposition) return;
    inputField.classList.remove('cm-in-composition');
    cm.display.inCompositionMode = false;
  });
}