"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cson2yaml = void 0;
function cson2yaml(cson) {
    const lines = cson.split('\n');
    const res = [];
    let inArray = false;
    for (const line of lines) {
        if (line.endsWith('[')) {
            inArray = true;
            res.push(line);
            continue;
        }
        else if (line.endsWith(']')) {
            inArray = false;
        }
        res.push(line + (inArray ? ',' : ''));
    }
    return res.join('\n');
}
exports.cson2yaml = cson2yaml;
//# sourceMappingURL=index.js.map