export declare const appName = "Inkdrop";
export declare const contactMaddr = "contact@inkdrop.app";
export declare const webUrl = "https://www.inkdrop.app/";
export declare const appUrl = "https://my.inkdrop.app/";
export declare const docUrl = "https://docs.inkdrop.app/";
export declare const forumUrl = "https://forum.inkdrop.app/";
export declare const creditsUrl = "https://github.com/inkdropapp/licenses/blob/master/README.md";
export type PlanType = 'basic_usd_m' | 'basic_usd_y' | 'basic_m' | 'basic_y';
export declare const planType: {
    basicMonthly: 'basic_usd_m';
    basicYearly: 'basic_usd_y';
    basicMonthlyJPY: 'basic_m';
    basicYearlyJPY: 'basic_y';
};
export type SessionStatus = 'active' | 'notLoggedIn' | 'unauthorized' | 'trialExpired' | 'sessionExpired' | 'oldVersion';
export declare const sessionStatus: {
    ACTIVE: 'active';
    NOT_LOGGED_IN: 'notLoggedIn';
    UNAUTHORIZED: 'unauthorized';
    TRIAL_EXPIRED: 'trialExpired';
    SESSION_EXPIRED: 'sessionExpired';
    OLD_VERSION: 'oldVersion';
};
export declare const taxPercentage = 8;
export declare class AssistiveError extends Error {
    detail: string;
    debugInfo: Record<string, any>;
    constructor(opts: {
        message: string;
        detail: string;
        debugInfo: Record<string, any>;
    });
}
