import type { ValidateFunction } from 'ajv';
import BookSchema from '../json-schema/book.json';
import type { EncryptedData } from './crypto';
export type BookMetadata = {
    _id: string;
    _rev?: string;
    updatedAt: number;
    createdAt: number;
    count?: number;
    parentBookId?: null | string;
    migratedBy?: string;
};
export type Book = BookMetadata & {
    name: string;
};
export type EncryptedBook = BookMetadata & {
    encryptedData: EncryptedData;
};
declare const validateBook: ValidateFunction<Book>;
export { BookSchema, validateBook };
