/// <reference types="node" />
import type { ValidateFunction } from 'ajv';
import FileSchema from '../json-schema/file.json';
import type { EncryptionMetadata } from './crypto';
export type ImageFileType = 'image/png' | 'image/jpeg' | 'image/jpg' | 'image/svg+xml' | 'image/gif' | 'image/heic' | 'image/heif';
export declare const supportedImageFileTypes: ReadonlyArray<ImageFileType>;
export declare const SUPPORTED_IMAGE_MIME_TYPES: {
    readonly [mime: string]: ImageFileType;
};
export declare const maxAttachmentFileSize: number;
export type FileAttachmentItem = {
    digest?: string;
    content_type: ImageFileType;
    data: Buffer | string;
    length?: number;
};
export type File = {
    _id: string;
    _rev?: string;
    name: string;
    createdAt: number;
    contentType: ImageFileType;
    contentLength: number;
    publicIn: string[];
    _attachments: {
        index: FileAttachmentItem;
    };
    md5digest?: string;
};
export type EncryptedFile = File & {
    encryptionData: EncryptionMetadata;
};
declare const validateFile: ValidateFunction<File>;
export { FileSchema, validateFile };
