import validator from '../validators/note';
import validator$1 from '../validators/book';
import validator$2 from '../validators/tag';
import validator$3 from '../validators/file';

var $schema$3 = "http://json-schema.org/draft-07/schema#";
var $id$3 = "note";
var title$3 = "Note";
var description$3 = "A note data";
var type$3 = "object";
var properties$3 = {
	_id: {
		description: "The unique document ID which should start with `note:` and the remains are randomly generated string",
		type: "string",
		minLength: 6,
		maxLength: 128,
		pattern: "^note:"
	},
	_rev: {
		description: "This is a CouchDB specific field. The current MVCC-token/revision of this document (mandatory and immutable).",
		type: "string"
	},
	bookId: {
		description: "The notebook ID",
		type: "string",
		minLength: 5,
		maxLength: 128,
		pattern: "^(book:|trash$)"
	},
	title: {
		description: "The note title",
		type: "string",
		maxLength: 128
	},
	doctype: {
		description: "The format type of the body field. It currently can take markdown only, reserved for the future",
		type: "string",
		"enum": [
			"markdown"
		]
	},
	body: {
		description: "The content of the note represented with Markdown",
		type: "string",
		maxLength: 1048576
	},
	updatedAt: {
		description: "The date time when the note was last updated, represented with Unix timestamps in milliseconds",
		type: "number"
	},
	createdAt: {
		description: "The date time when the note was created, represented with Unix timestamps in milliseconds",
		type: "number"
	},
	tags: {
		description: "The list of tag IDs",
		type: "array",
		items: {
			type: "string"
		},
		uniqueItems: true
	},
	numOfTasks: {
		description: "The number of tasks, extracted from body",
		type: "number"
	},
	numOfCheckedTasks: {
		description: "The number of checked tasks, extracted from body",
		type: "number"
	},
	migratedBy: {
		description: "The type of the data migration",
		type: "string",
		maxLength: 128
	},
	status: {
		description: "The status of the note",
		type: "string",
		"enum": [
			"none",
			"active",
			"onHold",
			"completed",
			"dropped"
		]
	},
	share: {
		description: "The sharing mode of the note",
		type: "string",
		"enum": [
			"private",
			"public"
		]
	},
	pinned: {
		description: "Whether the note is pinned to top",
		type: "boolean"
	},
	_conflicts: {
		description: "Conflicted revisions",
		type: "array",
		items: {
			type: "string"
		},
		uniqueItems: true
	}
};
var required$3 = [
	"_id",
	"bookId",
	"title",
	"doctype",
	"body",
	"updatedAt",
	"createdAt"
];
var note = {
	$schema: $schema$3,
	$id: $id$3,
	title: title$3,
	description: description$3,
	type: type$3,
	properties: properties$3,
	required: required$3
};

var TRASH_BOOK_ID = 'trash';
var NOTE_STATUS = {
    NONE: 'none',
    ACTIVE: 'active',
    ON_HOLD: 'onHold',
    COMPLETED: 'completed',
    DROPPED: 'dropped'
};
var NOTE_VISIBILITY = {
    PRIVATE: 'private',
    PUBLIC: 'public'
};
var validateNote = validator;

var $schema$2 = "http://json-schema.org/draft-07/schema#";
var $id$2 = "book";
var title$2 = "Book";
var description$2 = "A notebook data";
var type$2 = "object";
var properties$2 = {
	_id: {
		description: "The unique notebook ID which should start with `book:` and the remains are randomly generated string",
		type: "string",
		minLength: 6,
		maxLength: 128,
		pattern: "^book:"
	},
	_rev: {
		description: "This is a CouchDB specific field. The current MVCC-token/revision of this document (mandatory and immutable)",
		type: "string"
	},
	name: {
		description: "The notebook name",
		type: "string",
		minLength: 1,
		maxLength: 64
	},
	updatedAt: {
		description: "The date time when the notebook was last updated, represented with Unix timestamps in milliseconds",
		type: "number"
	},
	createdAt: {
		description: "The date time when the notebook was created, represented with Unix timestamps in milliseconds",
		type: "number"
	},
	count: {
		description: "It indicates the number of notes in the notebook",
		type: "number"
	},
	parentBookId: {
		description: "The ID of the parent notebook",
		type: [
			"string",
			"null"
		]
	}
};
var required$2 = [
	"_id",
	"name",
	"updatedAt",
	"createdAt"
];
var book = {
	$schema: $schema$2,
	$id: $id$2,
	title: title$2,
	description: description$2,
	type: type$2,
	properties: properties$2,
	required: required$2
};

var validateBook = validator$1;

var $schema$1 = "http://json-schema.org/draft-07/schema#";
var $id$1 = "tag";
var title$1 = "Tag";
var description$1 = "A note tag";
var type$1 = "object";
var properties$1 = {
	_id: {
		description: "The unique tag ID which should start with `tag:` and the remains are randomly generated string",
		type: "string",
		minLength: 6,
		maxLength: 128,
		pattern: "^tag:"
	},
	_rev: {
		description: "This is a CouchDB specific field. The current MVCC-token/revision of this document (mandatory and immutable)",
		type: "string"
	},
	name: {
		description: "The name of the tag",
		type: "string",
		maxLength: 64
	},
	count: {
		description: "It indicates the number of notes with the tag",
		type: "number"
	},
	color: {
		description: "The color type of the tag",
		type: "string",
		"enum": [
			"default",
			"red",
			"orange",
			"yellow",
			"olive",
			"green",
			"teal",
			"blue",
			"violet",
			"purple",
			"pink",
			"brown",
			"grey",
			"black"
		]
	},
	updatedAt: {
		description: "The date time when the tag was last updated, represented with Unix timestamps in milliseconds",
		type: "number"
	},
	createdAt: {
		description: "The date time when the tag was created, represented with Unix timestamps in milliseconds",
		type: "number"
	}
};
var required$1 = [
	"_id",
	"name",
	"count",
	"updatedAt",
	"createdAt"
];
var tag = {
	$schema: $schema$1,
	$id: $id$1,
	title: title$1,
	description: description$1,
	type: type$1,
	properties: properties$1,
	required: required$1
};

var TAG_COLOR = {
    DEFAULT: 'default',
    RED: 'red',
    ORANGE: 'orange',
    YELLOW: 'yellow',
    OLIVE: 'olive',
    GREEN: 'green',
    TEAL: 'teal',
    BLUE: 'blue',
    VIOLET: 'violet',
    PURPLE: 'purple',
    PINK: 'pink',
    BROWN: 'brown',
    GREY: 'grey',
    BLACK: 'black'
};
var validateTag = validator$2;

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

var $schema = "http://json-schema.org/draft-07/schema#";
var $id = "file";
var title = "File";
var description = "An attachment file";
var type = "object";
var properties = {
	_id: {
		description: "The unique document ID which should start with `file:` and the remains are randomly generated string",
		type: "string",
		minLength: 6,
		maxLength: 128,
		pattern: "^file:"
	},
	_rev: {
		description: "This is a CouchDB specific field. The current MVCC-token/revision of this document (mandatory and immutable).",
		type: "string"
	},
	name: {
		description: "The file name",
		type: "string",
		minLength: 1,
		maxLength: 128
	},
	createdAt: {
		description: "The date time when the note was created, represented with Unix timestamps in milliseconds",
		type: "number"
	},
	contentType: {
		description: "The MIME type of the content",
		type: "string",
		"enum": [
			"image/png",
			"image/jpeg",
			"image/jpg",
			"image/svg+xml",
			"image/gif",
			"image/heic",
			"image/heif"
		],
		maxLength: 128
	},
	contentLength: {
		description: "The content length of the file",
		type: "number",
		maximum: 10485760
	},
	publicIn: {
		description: "An array of the note IDs where the file is included",
		type: "array",
		items: {
			type: "string"
		},
		uniqueItems: true
	},
	_attachments: {
		description: "The attachment file",
		type: "object",
		properties: {
			index: {
				description: "The attachment file",
				type: "object",
				properties: {
					content_type: {
						description: "The content type of the file",
						type: "string",
						"enum": [
							"image/png",
							"image/jpeg",
							"image/jpg",
							"image/svg+xml",
							"image/gif",
							"image/heic",
							"image/heif"
						]
					},
					data: {
						description: "The file data",
						type: [
							"string",
							"object"
						]
					}
				},
				required: [
					"content_type",
					"data"
				]
			}
		},
		required: [
			"index"
		]
	}
};
var required = [
	"_id",
	"name",
	"createdAt",
	"contentType",
	"contentLength",
	"publicIn",
	"_attachments"
];
var file = {
	$schema: $schema,
	$id: $id,
	title: title,
	description: description,
	type: type,
	properties: properties,
	required: required
};

var supportedImageFileTypes = [
    'image/png',
    'image/jpeg',
    'image/jpg',
    'image/svg+xml',
    'image/gif',
    'image/heic',
    'image/heif'
];
var SUPPORTED_IMAGE_MIME_TYPES = __assign(__assign({}, supportedImageFileTypes.reduce(function (hash, ft) {
    var _a;
    return (__assign(__assign({}, hash), (_a = {}, _a[ft.split('/')[1]] = ft, _a)));
}, {})), { jpg: 'image/jpeg' });
var maxAttachmentFileSize = 10 * 1024 * 1024;
var validateFile = validator$3;

function validationErrorsToMessage(errors) {
    if (errors instanceof Array) {
        return errors
            .map(function (e) {
            if (typeof e === 'object') {
                return "\"".concat(e.instancePath, "\" ").concat(e.message);
            }
            else {
                return e;
            }
        })
            .join(', ');
    }
    else {
        return errors;
    }
}
var InvalidDataError = /** @class */ (function (_super) {
    __extends(InvalidDataError, _super);
    function InvalidDataError(message, errors) {
        var _this = _super.call(this, message + ' ' + validationErrorsToMessage(errors)) || this;
        _this.name = 'InvalidDataError';
        _this.errors = errors;
        return _this;
    }
    return InvalidDataError;
}(Error));

export { book as BookSchema, file as FileSchema, InvalidDataError, NOTE_STATUS, NOTE_VISIBILITY, note as NoteSchema, SUPPORTED_IMAGE_MIME_TYPES, TAG_COLOR, TRASH_BOOK_ID, tag as TagSchema, maxAttachmentFileSize, supportedImageFileTypes, validateBook, validateFile, validateNote, validateTag, validationErrorsToMessage };
//# sourceMappingURL=index.esm.js.map
