!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("../validators/note"),require("../validators/book"),require("../validators/tag"),require("../validators/file")):"function"==typeof define&&define.amd?define(["exports","../validators/note","../validators/book","../validators/tag","../validators/file"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).InkdropModel={},e.validator,e.validator$1,e.validator$2,e.validator$3)}(this,(function(e,t,i,n,r){"use strict";var o={$schema:"http://json-schema.org/draft-07/schema#",$id:"note",title:"Note",description:"A note data",type:"object",properties:{_id:{description:"The unique document ID which should start with `note:` and the remains are randomly generated string",type:"string",minLength:6,maxLength:128,pattern:"^note:"},_rev:{description:"This is a CouchDB specific field. The current MVCC-token/revision of this document (mandatory and immutable).",type:"string"},bookId:{description:"The notebook ID",type:"string",minLength:5,maxLength:128,pattern:"^(book:|trash$)"},title:{description:"The note title",type:"string",maxLength:128},doctype:{description:"The format type of the body field. It currently can take markdown only, reserved for the future",type:"string",enum:["markdown"]},body:{description:"The content of the note represented with Markdown",type:"string",maxLength:1048576},updatedAt:{description:"The date time when the note was last updated, represented with Unix timestamps in milliseconds",type:"number"},createdAt:{description:"The date time when the note was created, represented with Unix timestamps in milliseconds",type:"number"},tags:{description:"The list of tag IDs",type:"array",items:{type:"string"},uniqueItems:!0},numOfTasks:{description:"The number of tasks, extracted from body",type:"number"},numOfCheckedTasks:{description:"The number of checked tasks, extracted from body",type:"number"},migratedBy:{description:"The type of the data migration",type:"string",maxLength:128},status:{description:"The status of the note",type:"string",enum:["none","active","onHold","completed","dropped"]},share:{description:"The sharing mode of the note",type:"string",enum:["private","public"]},pinned:{description:"Whether the note is pinned to top",type:"boolean"},_conflicts:{description:"Conflicted revisions",type:"array",items:{type:"string"},uniqueItems:!0}},required:["_id","bookId","title","doctype","body","updatedAt","createdAt"]},a=t,s={$schema:"http://json-schema.org/draft-07/schema#",$id:"book",title:"Book",description:"A notebook data",type:"object",properties:{_id:{description:"The unique notebook ID which should start with `book:` and the remains are randomly generated string",type:"string",minLength:6,maxLength:128,pattern:"^book:"},_rev:{description:"This is a CouchDB specific field. The current MVCC-token/revision of this document (mandatory and immutable)",type:"string"},name:{description:"The notebook name",type:"string",minLength:1,maxLength:64},updatedAt:{description:"The date time when the notebook was last updated, represented with Unix timestamps in milliseconds",type:"number"},createdAt:{description:"The date time when the notebook was created, represented with Unix timestamps in milliseconds",type:"number"},count:{description:"It indicates the number of notes in the notebook",type:"number"},parentBookId:{description:"The ID of the parent notebook",type:["string","null"]}},required:["_id","name","updatedAt","createdAt"]},d=i,p={$schema:"http://json-schema.org/draft-07/schema#",$id:"tag",title:"Tag",description:"A note tag",type:"object",properties:{_id:{description:"The unique tag ID which should start with `tag:` and the remains are randomly generated string",type:"string",minLength:6,maxLength:128,pattern:"^tag:"},_rev:{description:"This is a CouchDB specific field. The current MVCC-token/revision of this document (mandatory and immutable)",type:"string"},name:{description:"The name of the tag",type:"string",maxLength:64},count:{description:"It indicates the number of notes with the tag",type:"number"},color:{description:"The color type of the tag",type:"string",enum:["default","red","orange","yellow","olive","green","teal","blue","violet","purple","pink","brown","grey","black"]},updatedAt:{description:"The date time when the tag was last updated, represented with Unix timestamps in milliseconds",type:"number"},createdAt:{description:"The date time when the tag was created, represented with Unix timestamps in milliseconds",type:"number"}},required:["_id","name","count","updatedAt","createdAt"]},c=n,h=function(e,t){return h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i])},h(e,t)};var m=function(){return m=Object.assign||function(e){for(var t,i=1,n=arguments.length;i<n;i++)for(var r in t=arguments[i])Object.prototype.hasOwnProperty.call(t,r)&&(e[r]=t[r]);return e},m.apply(this,arguments)},l={$schema:"http://json-schema.org/draft-07/schema#",$id:"file",title:"File",description:"An attachment file",type:"object",properties:{_id:{description:"The unique document ID which should start with `file:` and the remains are randomly generated string",type:"string",minLength:6,maxLength:128,pattern:"^file:"},_rev:{description:"This is a CouchDB specific field. The current MVCC-token/revision of this document (mandatory and immutable).",type:"string"},name:{description:"The file name",type:"string",minLength:1,maxLength:128},createdAt:{description:"The date time when the note was created, represented with Unix timestamps in milliseconds",type:"number"},contentType:{description:"The MIME type of the content",type:"string",enum:["image/png","image/jpeg","image/jpg","image/svg+xml","image/gif","image/heic","image/heif"],maxLength:128},contentLength:{description:"The content length of the file",type:"number",maximum:10485760},publicIn:{description:"An array of the note IDs where the file is included",type:"array",items:{type:"string"},uniqueItems:!0},_attachments:{description:"The attachment file",type:"object",properties:{index:{description:"The attachment file",type:"object",properties:{content_type:{description:"The content type of the file",type:"string",enum:["image/png","image/jpeg","image/jpg","image/svg+xml","image/gif","image/heic","image/heif"]},data:{description:"The file data",type:["string","object"]}},required:["content_type","data"]}},required:["index"]}},required:["_id","name","createdAt","contentType","contentLength","publicIn","_attachments"]},u=["image/png","image/jpeg","image/jpg","image/svg+xml","image/gif","image/heic","image/heif"],g=m(m({},u.reduce((function(e,t){var i;return m(m({},e),((i={})[t.split("/")[1]]=t,i))}),{})),{jpg:"image/jpeg"}),y=r;function f(e){return e instanceof Array?e.map((function(e){return"object"==typeof e?'"'.concat(e.instancePath,'" ').concat(e.message):e})).join(", "):e}var b=function(e){function t(t,i){var n=e.call(this,t+" "+f(i))||this;return n.name="InvalidDataError",n.errors=i,n}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function i(){this.constructor=e}h(e,t),e.prototype=null===t?Object.create(t):(i.prototype=t.prototype,new i)}(t,e),t}(Error);e.BookSchema=s,e.FileSchema=l,e.InvalidDataError=b,e.NOTE_STATUS={NONE:"none",ACTIVE:"active",ON_HOLD:"onHold",COMPLETED:"completed",DROPPED:"dropped"},e.NOTE_VISIBILITY={PRIVATE:"private",PUBLIC:"public"},e.NoteSchema=o,e.SUPPORTED_IMAGE_MIME_TYPES=g,e.TAG_COLOR={DEFAULT:"default",RED:"red",ORANGE:"orange",YELLOW:"yellow",OLIVE:"olive",GREEN:"green",TEAL:"teal",BLUE:"blue",VIOLET:"violet",PURPLE:"purple",PINK:"pink",BROWN:"brown",GREY:"grey",BLACK:"black"},e.TRASH_BOOK_ID="trash",e.TagSchema=p,e.maxAttachmentFileSize=10485760,e.supportedImageFileTypes=u,e.validateBook=d,e.validateFile=y,e.validateNote=a,e.validateTag=c,e.validationErrorsToMessage=f}));
