"use strict";module.exports = validate20;module.exports.default = validate20;const schema22 = {"$schema":"http://json-schema.org/draft-07/schema#","$id":"book","title":"Book","description":"A notebook data","type":"object","properties":{"_id":{"description":"The unique notebook ID which should start with `book:` and the remains are randomly generated string","type":"string","minLength":6,"maxLength":128,"pattern":"^book:"},"_rev":{"description":"This is a CouchDB specific field. The current MVCC-token/revision of this document (mandatory and immutable)","type":"string"},"name":{"description":"The notebook name","type":"string","minLength":1,"maxLength":64},"updatedAt":{"description":"The date time when the notebook was last updated, represented with Unix timestamps in milliseconds","type":"number"},"createdAt":{"description":"The date time when the notebook was created, represented with Unix timestamps in milliseconds","type":"number"},"count":{"description":"It indicates the number of notes in the notebook","type":"number"},"parentBookId":{"description":"The ID of the parent notebook","type":["string","null"]}},"required":["_id","name","updatedAt","createdAt"]};const func4 = require("ajv/dist/runtime/ucs2length").default;const pattern0 = new RegExp("^book:", "u");function validate20(data, {instancePath="", parentData, parentDataProperty, rootData=data}={}){/*# sourceURL="book" */;let vErrors = null;let errors = 0;if(errors === 0){if(data && typeof data == "object" && !Array.isArray(data)){let missing0;if(((((data._id === undefined) && (missing0 = "_id")) || ((data.name === undefined) && (missing0 = "name"))) || ((data.updatedAt === undefined) && (missing0 = "updatedAt"))) || ((data.createdAt === undefined) && (missing0 = "createdAt"))){validate20.errors = [{instancePath,schemaPath:"#/required",keyword:"required",params:{missingProperty: missing0},message:"must have required property '"+missing0+"'"}];return false;}else {if(data._id !== undefined){let data0 = data._id;const _errs1 = errors;if(errors === _errs1){if(typeof data0 === "string"){if(func4(data0) > 128){validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/maxLength",keyword:"maxLength",params:{limit: 128},message:"must NOT have more than 128 characters"}];return false;}else {if(func4(data0) < 6){validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/minLength",keyword:"minLength",params:{limit: 6},message:"must NOT have fewer than 6 characters"}];return false;}else {if(!pattern0.test(data0)){validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/pattern",keyword:"pattern",params:{pattern: "^book:"},message:"must match pattern \""+"^book:"+"\""}];return false;}}}}else {validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}}var valid0 = _errs1 === errors;}else {var valid0 = true;}if(valid0){if(data._rev !== undefined){const _errs3 = errors;if(typeof data._rev !== "string"){validate20.errors = [{instancePath:instancePath+"/_rev",schemaPath:"#/properties/_rev/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs3 === errors;}else {var valid0 = true;}if(valid0){if(data.name !== undefined){let data2 = data.name;const _errs5 = errors;if(errors === _errs5){if(typeof data2 === "string"){if(func4(data2) > 64){validate20.errors = [{instancePath:instancePath+"/name",schemaPath:"#/properties/name/maxLength",keyword:"maxLength",params:{limit: 64},message:"must NOT have more than 64 characters"}];return false;}else {if(func4(data2) < 1){validate20.errors = [{instancePath:instancePath+"/name",schemaPath:"#/properties/name/minLength",keyword:"minLength",params:{limit: 1},message:"must NOT have fewer than 1 characters"}];return false;}}}else {validate20.errors = [{instancePath:instancePath+"/name",schemaPath:"#/properties/name/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}}var valid0 = _errs5 === errors;}else {var valid0 = true;}if(valid0){if(data.updatedAt !== undefined){let data3 = data.updatedAt;const _errs7 = errors;if(!((typeof data3 == "number") && (isFinite(data3)))){validate20.errors = [{instancePath:instancePath+"/updatedAt",schemaPath:"#/properties/updatedAt/type",keyword:"type",params:{type: "number"},message:"must be number"}];return false;}var valid0 = _errs7 === errors;}else {var valid0 = true;}if(valid0){if(data.createdAt !== undefined){let data4 = data.createdAt;const _errs9 = errors;if(!((typeof data4 == "number") && (isFinite(data4)))){validate20.errors = [{instancePath:instancePath+"/createdAt",schemaPath:"#/properties/createdAt/type",keyword:"type",params:{type: "number"},message:"must be number"}];return false;}var valid0 = _errs9 === errors;}else {var valid0 = true;}if(valid0){if(data.count !== undefined){let data5 = data.count;const _errs11 = errors;if(!((typeof data5 == "number") && (isFinite(data5)))){validate20.errors = [{instancePath:instancePath+"/count",schemaPath:"#/properties/count/type",keyword:"type",params:{type: "number"},message:"must be number"}];return false;}var valid0 = _errs11 === errors;}else {var valid0 = true;}if(valid0){if(data.parentBookId !== undefined){let data6 = data.parentBookId;const _errs13 = errors;if((typeof data6 !== "string") && (data6 !== null)){validate20.errors = [{instancePath:instancePath+"/parentBookId",schemaPath:"#/properties/parentBookId/type",keyword:"type",params:{type: schema22.properties.parentBookId.type},message:"must be string,null"}];return false;}var valid0 = _errs13 === errors;}else {var valid0 = true;}}}}}}}}}else {validate20.errors = [{instancePath,schemaPath:"#/type",keyword:"type",params:{type: "object"},message:"must be object"}];return false;}}validate20.errors = vErrors;return errors === 0;}