"use strict";module.exports = validate20;module.exports.default = validate20;const schema22 = {"$schema":"http://json-schema.org/draft-07/schema#","$id":"file","title":"File","description":"An attachment file","type":"object","properties":{"_id":{"description":"The unique document ID which should start with `file:` and the remains are randomly generated string","type":"string","minLength":6,"maxLength":128,"pattern":"^file:"},"_rev":{"description":"This is a CouchDB specific field. The current MVCC-token/revision of this document (mandatory and immutable).","type":"string"},"name":{"description":"The file name","type":"string","minLength":1,"maxLength":128},"createdAt":{"description":"The date time when the note was created, represented with Unix timestamps in milliseconds","type":"number"},"contentType":{"description":"The MIME type of the content","type":"string","enum":["image/png","image/jpeg","image/jpg","image/svg+xml","image/gif","image/heic","image/heif"],"maxLength":128},"contentLength":{"description":"The content length of the file","type":"number","maximum":10485760},"publicIn":{"description":"An array of the note IDs where the file is included","type":"array","items":{"type":"string"},"uniqueItems":true},"_attachments":{"description":"The attachment file","type":"object","properties":{"index":{"description":"The attachment file","type":"object","properties":{"content_type":{"description":"The content type of the file","type":"string","enum":["image/png","image/jpeg","image/jpg","image/svg+xml","image/gif","image/heic","image/heif"]},"data":{"description":"The file data","type":["string","object"]}},"required":["content_type","data"]}},"required":["index"]}},"required":["_id","name","createdAt","contentType","contentLength","publicIn","_attachments"]};const func4 = require("ajv/dist/runtime/ucs2length").default;const pattern0 = new RegExp("^file:", "u");function validate20(data, {instancePath="", parentData, parentDataProperty, rootData=data}={}){/*# sourceURL="file" */;let vErrors = null;let errors = 0;if(errors === 0){if(data && typeof data == "object" && !Array.isArray(data)){let missing0;if((((((((data._id === undefined) && (missing0 = "_id")) || ((data.name === undefined) && (missing0 = "name"))) || ((data.createdAt === undefined) && (missing0 = "createdAt"))) || ((data.contentType === undefined) && (missing0 = "contentType"))) || ((data.contentLength === undefined) && (missing0 = "contentLength"))) || ((data.publicIn === undefined) && (missing0 = "publicIn"))) || ((data._attachments === undefined) && (missing0 = "_attachments"))){validate20.errors = [{instancePath,schemaPath:"#/required",keyword:"required",params:{missingProperty: missing0},message:"must have required property '"+missing0+"'"}];return false;}else {if(data._id !== undefined){let data0 = data._id;const _errs1 = errors;if(errors === _errs1){if(typeof data0 === "string"){if(func4(data0) > 128){validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/maxLength",keyword:"maxLength",params:{limit: 128},message:"must NOT have more than 128 characters"}];return false;}else {if(func4(data0) < 6){validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/minLength",keyword:"minLength",params:{limit: 6},message:"must NOT have fewer than 6 characters"}];return false;}else {if(!pattern0.test(data0)){validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/pattern",keyword:"pattern",params:{pattern: "^file:"},message:"must match pattern \""+"^file:"+"\""}];return false;}}}}else {validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}}var valid0 = _errs1 === errors;}else {var valid0 = true;}if(valid0){if(data._rev !== undefined){const _errs3 = errors;if(typeof data._rev !== "string"){validate20.errors = [{instancePath:instancePath+"/_rev",schemaPath:"#/properties/_rev/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs3 === errors;}else {var valid0 = true;}if(valid0){if(data.name !== undefined){let data2 = data.name;const _errs5 = errors;if(errors === _errs5){if(typeof data2 === "string"){if(func4(data2) > 128){validate20.errors = [{instancePath:instancePath+"/name",schemaPath:"#/properties/name/maxLength",keyword:"maxLength",params:{limit: 128},message:"must NOT have more than 128 characters"}];return false;}else {if(func4(data2) < 1){validate20.errors = [{instancePath:instancePath+"/name",schemaPath:"#/properties/name/minLength",keyword:"minLength",params:{limit: 1},message:"must NOT have fewer than 1 characters"}];return false;}}}else {validate20.errors = [{instancePath:instancePath+"/name",schemaPath:"#/properties/name/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}}var valid0 = _errs5 === errors;}else {var valid0 = true;}if(valid0){if(data.createdAt !== undefined){let data3 = data.createdAt;const _errs7 = errors;if(!((typeof data3 == "number") && (isFinite(data3)))){validate20.errors = [{instancePath:instancePath+"/createdAt",schemaPath:"#/properties/createdAt/type",keyword:"type",params:{type: "number"},message:"must be number"}];return false;}var valid0 = _errs7 === errors;}else {var valid0 = true;}if(valid0){if(data.contentType !== undefined){let data4 = data.contentType;const _errs9 = errors;if(!(((((((data4 === "image/png") || (data4 === "image/jpeg")) || (data4 === "image/jpg")) || (data4 === "image/svg+xml")) || (data4 === "image/gif")) || (data4 === "image/heic")) || (data4 === "image/heif"))){validate20.errors = [{instancePath:instancePath+"/contentType",schemaPath:"#/properties/contentType/enum",keyword:"enum",params:{allowedValues: schema22.properties.contentType.enum},message:"must be equal to one of the allowed values"}];return false;}if(errors === _errs9){if(typeof data4 === "string"){if(func4(data4) > 128){validate20.errors = [{instancePath:instancePath+"/contentType",schemaPath:"#/properties/contentType/maxLength",keyword:"maxLength",params:{limit: 128},message:"must NOT have more than 128 characters"}];return false;}}else {validate20.errors = [{instancePath:instancePath+"/contentType",schemaPath:"#/properties/contentType/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}}var valid0 = _errs9 === errors;}else {var valid0 = true;}if(valid0){if(data.contentLength !== undefined){let data5 = data.contentLength;const _errs11 = errors;if(errors === _errs11){if((typeof data5 == "number") && (isFinite(data5))){if(data5 > 10485760 || isNaN(data5)){validate20.errors = [{instancePath:instancePath+"/contentLength",schemaPath:"#/properties/contentLength/maximum",keyword:"maximum",params:{comparison: "<=", limit: 10485760},message:"must be <= 10485760"}];return false;}}else {validate20.errors = [{instancePath:instancePath+"/contentLength",schemaPath:"#/properties/contentLength/type",keyword:"type",params:{type: "number"},message:"must be number"}];return false;}}var valid0 = _errs11 === errors;}else {var valid0 = true;}if(valid0){if(data.publicIn !== undefined){let data6 = data.publicIn;const _errs13 = errors;if(errors === _errs13){if(Array.isArray(data6)){var valid1 = true;const len0 = data6.length;for(let i0=0; i0<len0; i0++){const _errs15 = errors;if(typeof data6[i0] !== "string"){validate20.errors = [{instancePath:instancePath+"/publicIn/" + i0,schemaPath:"#/properties/publicIn/items/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid1 = _errs15 === errors;if(!valid1){break;}}if(valid1){let i1 = data6.length;let j0;if(i1 > 1){const indices0 = {};for(;i1--;){let item0 = data6[i1];if(typeof item0 !== "string"){continue;}if(typeof indices0[item0] == "number"){j0 = indices0[item0];validate20.errors = [{instancePath:instancePath+"/publicIn",schemaPath:"#/properties/publicIn/uniqueItems",keyword:"uniqueItems",params:{i: i1, j: j0},message:"must NOT have duplicate items (items ## "+j0+" and "+i1+" are identical)"}];return false;break;}indices0[item0] = i1;}}}}else {validate20.errors = [{instancePath:instancePath+"/publicIn",schemaPath:"#/properties/publicIn/type",keyword:"type",params:{type: "array"},message:"must be array"}];return false;}}var valid0 = _errs13 === errors;}else {var valid0 = true;}if(valid0){if(data._attachments !== undefined){let data8 = data._attachments;const _errs17 = errors;if(errors === _errs17){if(data8 && typeof data8 == "object" && !Array.isArray(data8)){let missing1;if((data8.index === undefined) && (missing1 = "index")){validate20.errors = [{instancePath:instancePath+"/_attachments",schemaPath:"#/properties/_attachments/required",keyword:"required",params:{missingProperty: missing1},message:"must have required property '"+missing1+"'"}];return false;}else {if(data8.index !== undefined){let data9 = data8.index;const _errs19 = errors;if(errors === _errs19){if(data9 && typeof data9 == "object" && !Array.isArray(data9)){let missing2;if(((data9.content_type === undefined) && (missing2 = "content_type")) || ((data9.data === undefined) && (missing2 = "data"))){validate20.errors = [{instancePath:instancePath+"/_attachments/index",schemaPath:"#/properties/_attachments/properties/index/required",keyword:"required",params:{missingProperty: missing2},message:"must have required property '"+missing2+"'"}];return false;}else {if(data9.content_type !== undefined){let data10 = data9.content_type;const _errs21 = errors;if(typeof data10 !== "string"){validate20.errors = [{instancePath:instancePath+"/_attachments/index/content_type",schemaPath:"#/properties/_attachments/properties/index/properties/content_type/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}if(!(((((((data10 === "image/png") || (data10 === "image/jpeg")) || (data10 === "image/jpg")) || (data10 === "image/svg+xml")) || (data10 === "image/gif")) || (data10 === "image/heic")) || (data10 === "image/heif"))){validate20.errors = [{instancePath:instancePath+"/_attachments/index/content_type",schemaPath:"#/properties/_attachments/properties/index/properties/content_type/enum",keyword:"enum",params:{allowedValues: schema22.properties._attachments.properties.index.properties.content_type.enum},message:"must be equal to one of the allowed values"}];return false;}var valid4 = _errs21 === errors;}else {var valid4 = true;}if(valid4){if(data9.data !== undefined){let data11 = data9.data;const _errs23 = errors;if((typeof data11 !== "string") && (!(data11 && typeof data11 == "object" && !Array.isArray(data11)))){validate20.errors = [{instancePath:instancePath+"/_attachments/index/data",schemaPath:"#/properties/_attachments/properties/index/properties/data/type",keyword:"type",params:{type: schema22.properties._attachments.properties.index.properties.data.type},message:"must be string,object"}];return false;}var valid4 = _errs23 === errors;}else {var valid4 = true;}}}}else {validate20.errors = [{instancePath:instancePath+"/_attachments/index",schemaPath:"#/properties/_attachments/properties/index/type",keyword:"type",params:{type: "object"},message:"must be object"}];return false;}}}}}else {validate20.errors = [{instancePath:instancePath+"/_attachments",schemaPath:"#/properties/_attachments/type",keyword:"type",params:{type: "object"},message:"must be object"}];return false;}}var valid0 = _errs17 === errors;}else {var valid0 = true;}}}}}}}}}}else {validate20.errors = [{instancePath,schemaPath:"#/type",keyword:"type",params:{type: "object"},message:"must be object"}];return false;}}validate20.errors = vErrors;return errors === 0;}