"use strict";module.exports = validate20;module.exports.default = validate20;const schema22 = {"$schema":"http://json-schema.org/draft-07/schema#","$id":"note","title":"Note","description":"A note data","type":"object","properties":{"_id":{"description":"The unique document ID which should start with `note:` and the remains are randomly generated string","type":"string","minLength":6,"maxLength":128,"pattern":"^note:"},"_rev":{"description":"This is a CouchDB specific field. The current MVCC-token/revision of this document (mandatory and immutable).","type":"string"},"bookId":{"description":"The notebook ID","type":"string","minLength":5,"maxLength":128,"pattern":"^(book:|trash$)"},"title":{"description":"The note title","type":"string","maxLength":128},"doctype":{"description":"The format type of the body field. It currently can take markdown only, reserved for the future","type":"string","enum":["markdown"]},"body":{"description":"The content of the note represented with Markdown","type":"string","maxLength":1048576},"updatedAt":{"description":"The date time when the note was last updated, represented with Unix timestamps in milliseconds","type":"number"},"createdAt":{"description":"The date time when the note was created, represented with Unix timestamps in milliseconds","type":"number"},"tags":{"description":"The list of tag IDs","type":"array","items":{"type":"string"},"uniqueItems":true},"numOfTasks":{"description":"The number of tasks, extracted from body","type":"number"},"numOfCheckedTasks":{"description":"The number of checked tasks, extracted from body","type":"number"},"migratedBy":{"description":"The type of the data migration","type":"string","maxLength":128},"status":{"description":"The status of the note","type":"string","enum":["none","active","onHold","completed","dropped"]},"share":{"description":"The sharing mode of the note","type":"string","enum":["private","public"]},"pinned":{"description":"Whether the note is pinned to top","type":"boolean"},"_conflicts":{"description":"Conflicted revisions","type":"array","items":{"type":"string"},"uniqueItems":true}},"required":["_id","bookId","title","doctype","body","updatedAt","createdAt"]};const func4 = require("ajv/dist/runtime/ucs2length").default;const pattern0 = new RegExp("^note:", "u");const pattern1 = new RegExp("^(book:|trash$)", "u");function validate20(data, {instancePath="", parentData, parentDataProperty, rootData=data}={}){/*# sourceURL="note" */;let vErrors = null;let errors = 0;if(errors === 0){if(data && typeof data == "object" && !Array.isArray(data)){let missing0;if((((((((data._id === undefined) && (missing0 = "_id")) || ((data.bookId === undefined) && (missing0 = "bookId"))) || ((data.title === undefined) && (missing0 = "title"))) || ((data.doctype === undefined) && (missing0 = "doctype"))) || ((data.body === undefined) && (missing0 = "body"))) || ((data.updatedAt === undefined) && (missing0 = "updatedAt"))) || ((data.createdAt === undefined) && (missing0 = "createdAt"))){validate20.errors = [{instancePath,schemaPath:"#/required",keyword:"required",params:{missingProperty: missing0},message:"must have required property '"+missing0+"'"}];return false;}else {if(data._id !== undefined){let data0 = data._id;const _errs1 = errors;if(errors === _errs1){if(typeof data0 === "string"){if(func4(data0) > 128){validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/maxLength",keyword:"maxLength",params:{limit: 128},message:"must NOT have more than 128 characters"}];return false;}else {if(func4(data0) < 6){validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/minLength",keyword:"minLength",params:{limit: 6},message:"must NOT have fewer than 6 characters"}];return false;}else {if(!pattern0.test(data0)){validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/pattern",keyword:"pattern",params:{pattern: "^note:"},message:"must match pattern \""+"^note:"+"\""}];return false;}}}}else {validate20.errors = [{instancePath:instancePath+"/_id",schemaPath:"#/properties/_id/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}}var valid0 = _errs1 === errors;}else {var valid0 = true;}if(valid0){if(data._rev !== undefined){const _errs3 = errors;if(typeof data._rev !== "string"){validate20.errors = [{instancePath:instancePath+"/_rev",schemaPath:"#/properties/_rev/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid0 = _errs3 === errors;}else {var valid0 = true;}if(valid0){if(data.bookId !== undefined){let data2 = data.bookId;const _errs5 = errors;if(errors === _errs5){if(typeof data2 === "string"){if(func4(data2) > 128){validate20.errors = [{instancePath:instancePath+"/bookId",schemaPath:"#/properties/bookId/maxLength",keyword:"maxLength",params:{limit: 128},message:"must NOT have more than 128 characters"}];return false;}else {if(func4(data2) < 5){validate20.errors = [{instancePath:instancePath+"/bookId",schemaPath:"#/properties/bookId/minLength",keyword:"minLength",params:{limit: 5},message:"must NOT have fewer than 5 characters"}];return false;}else {if(!pattern1.test(data2)){validate20.errors = [{instancePath:instancePath+"/bookId",schemaPath:"#/properties/bookId/pattern",keyword:"pattern",params:{pattern: "^(book:|trash$)"},message:"must match pattern \""+"^(book:|trash$)"+"\""}];return false;}}}}else {validate20.errors = [{instancePath:instancePath+"/bookId",schemaPath:"#/properties/bookId/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}}var valid0 = _errs5 === errors;}else {var valid0 = true;}if(valid0){if(data.title !== undefined){let data3 = data.title;const _errs7 = errors;if(errors === _errs7){if(typeof data3 === "string"){if(func4(data3) > 128){validate20.errors = [{instancePath:instancePath+"/title",schemaPath:"#/properties/title/maxLength",keyword:"maxLength",params:{limit: 128},message:"must NOT have more than 128 characters"}];return false;}}else {validate20.errors = [{instancePath:instancePath+"/title",schemaPath:"#/properties/title/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}}var valid0 = _errs7 === errors;}else {var valid0 = true;}if(valid0){if(data.doctype !== undefined){let data4 = data.doctype;const _errs9 = errors;if(typeof data4 !== "string"){validate20.errors = [{instancePath:instancePath+"/doctype",schemaPath:"#/properties/doctype/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}if(!(data4 === "markdown")){validate20.errors = [{instancePath:instancePath+"/doctype",schemaPath:"#/properties/doctype/enum",keyword:"enum",params:{allowedValues: schema22.properties.doctype.enum},message:"must be equal to one of the allowed values"}];return false;}var valid0 = _errs9 === errors;}else {var valid0 = true;}if(valid0){if(data.body !== undefined){let data5 = data.body;const _errs11 = errors;if(errors === _errs11){if(typeof data5 === "string"){if(func4(data5) > 1048576){validate20.errors = [{instancePath:instancePath+"/body",schemaPath:"#/properties/body/maxLength",keyword:"maxLength",params:{limit: 1048576},message:"must NOT have more than 1048576 characters"}];return false;}}else {validate20.errors = [{instancePath:instancePath+"/body",schemaPath:"#/properties/body/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}}var valid0 = _errs11 === errors;}else {var valid0 = true;}if(valid0){if(data.updatedAt !== undefined){let data6 = data.updatedAt;const _errs13 = errors;if(!((typeof data6 == "number") && (isFinite(data6)))){validate20.errors = [{instancePath:instancePath+"/updatedAt",schemaPath:"#/properties/updatedAt/type",keyword:"type",params:{type: "number"},message:"must be number"}];return false;}var valid0 = _errs13 === errors;}else {var valid0 = true;}if(valid0){if(data.createdAt !== undefined){let data7 = data.createdAt;const _errs15 = errors;if(!((typeof data7 == "number") && (isFinite(data7)))){validate20.errors = [{instancePath:instancePath+"/createdAt",schemaPath:"#/properties/createdAt/type",keyword:"type",params:{type: "number"},message:"must be number"}];return false;}var valid0 = _errs15 === errors;}else {var valid0 = true;}if(valid0){if(data.tags !== undefined){let data8 = data.tags;const _errs17 = errors;if(errors === _errs17){if(Array.isArray(data8)){var valid1 = true;const len0 = data8.length;for(let i0=0; i0<len0; i0++){const _errs19 = errors;if(typeof data8[i0] !== "string"){validate20.errors = [{instancePath:instancePath+"/tags/" + i0,schemaPath:"#/properties/tags/items/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid1 = _errs19 === errors;if(!valid1){break;}}if(valid1){let i1 = data8.length;let j0;if(i1 > 1){const indices0 = {};for(;i1--;){let item0 = data8[i1];if(typeof item0 !== "string"){continue;}if(typeof indices0[item0] == "number"){j0 = indices0[item0];validate20.errors = [{instancePath:instancePath+"/tags",schemaPath:"#/properties/tags/uniqueItems",keyword:"uniqueItems",params:{i: i1, j: j0},message:"must NOT have duplicate items (items ## "+j0+" and "+i1+" are identical)"}];return false;break;}indices0[item0] = i1;}}}}else {validate20.errors = [{instancePath:instancePath+"/tags",schemaPath:"#/properties/tags/type",keyword:"type",params:{type: "array"},message:"must be array"}];return false;}}var valid0 = _errs17 === errors;}else {var valid0 = true;}if(valid0){if(data.numOfTasks !== undefined){let data10 = data.numOfTasks;const _errs21 = errors;if(!((typeof data10 == "number") && (isFinite(data10)))){validate20.errors = [{instancePath:instancePath+"/numOfTasks",schemaPath:"#/properties/numOfTasks/type",keyword:"type",params:{type: "number"},message:"must be number"}];return false;}var valid0 = _errs21 === errors;}else {var valid0 = true;}if(valid0){if(data.numOfCheckedTasks !== undefined){let data11 = data.numOfCheckedTasks;const _errs23 = errors;if(!((typeof data11 == "number") && (isFinite(data11)))){validate20.errors = [{instancePath:instancePath+"/numOfCheckedTasks",schemaPath:"#/properties/numOfCheckedTasks/type",keyword:"type",params:{type: "number"},message:"must be number"}];return false;}var valid0 = _errs23 === errors;}else {var valid0 = true;}if(valid0){if(data.migratedBy !== undefined){let data12 = data.migratedBy;const _errs25 = errors;if(errors === _errs25){if(typeof data12 === "string"){if(func4(data12) > 128){validate20.errors = [{instancePath:instancePath+"/migratedBy",schemaPath:"#/properties/migratedBy/maxLength",keyword:"maxLength",params:{limit: 128},message:"must NOT have more than 128 characters"}];return false;}}else {validate20.errors = [{instancePath:instancePath+"/migratedBy",schemaPath:"#/properties/migratedBy/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}}var valid0 = _errs25 === errors;}else {var valid0 = true;}if(valid0){if(data.status !== undefined){let data13 = data.status;const _errs27 = errors;if(typeof data13 !== "string"){validate20.errors = [{instancePath:instancePath+"/status",schemaPath:"#/properties/status/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}if(!(((((data13 === "none") || (data13 === "active")) || (data13 === "onHold")) || (data13 === "completed")) || (data13 === "dropped"))){validate20.errors = [{instancePath:instancePath+"/status",schemaPath:"#/properties/status/enum",keyword:"enum",params:{allowedValues: schema22.properties.status.enum},message:"must be equal to one of the allowed values"}];return false;}var valid0 = _errs27 === errors;}else {var valid0 = true;}if(valid0){if(data.share !== undefined){let data14 = data.share;const _errs29 = errors;if(typeof data14 !== "string"){validate20.errors = [{instancePath:instancePath+"/share",schemaPath:"#/properties/share/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}if(!((data14 === "private") || (data14 === "public"))){validate20.errors = [{instancePath:instancePath+"/share",schemaPath:"#/properties/share/enum",keyword:"enum",params:{allowedValues: schema22.properties.share.enum},message:"must be equal to one of the allowed values"}];return false;}var valid0 = _errs29 === errors;}else {var valid0 = true;}if(valid0){if(data.pinned !== undefined){const _errs31 = errors;if(typeof data.pinned !== "boolean"){validate20.errors = [{instancePath:instancePath+"/pinned",schemaPath:"#/properties/pinned/type",keyword:"type",params:{type: "boolean"},message:"must be boolean"}];return false;}var valid0 = _errs31 === errors;}else {var valid0 = true;}if(valid0){if(data._conflicts !== undefined){let data16 = data._conflicts;const _errs33 = errors;if(errors === _errs33){if(Array.isArray(data16)){var valid3 = true;const len1 = data16.length;for(let i2=0; i2<len1; i2++){const _errs35 = errors;if(typeof data16[i2] !== "string"){validate20.errors = [{instancePath:instancePath+"/_conflicts/" + i2,schemaPath:"#/properties/_conflicts/items/type",keyword:"type",params:{type: "string"},message:"must be string"}];return false;}var valid3 = _errs35 === errors;if(!valid3){break;}}if(valid3){let i3 = data16.length;let j1;if(i3 > 1){const indices1 = {};for(;i3--;){let item1 = data16[i3];if(typeof item1 !== "string"){continue;}if(typeof indices1[item1] == "number"){j1 = indices1[item1];validate20.errors = [{instancePath:instancePath+"/_conflicts",schemaPath:"#/properties/_conflicts/uniqueItems",keyword:"uniqueItems",params:{i: i3, j: j1},message:"must NOT have duplicate items (items ## "+j1+" and "+i3+" are identical)"}];return false;break;}indices1[item1] = i3;}}}}else {validate20.errors = [{instancePath:instancePath+"/_conflicts",schemaPath:"#/properties/_conflicts/type",keyword:"type",params:{type: "array"},message:"must be array"}];return false;}}var valid0 = _errs33 === errors;}else {var valid0 = true;}}}}}}}}}}}}}}}}}}else {validate20.errors = [{instancePath,schemaPath:"#/type",keyword:"type",params:{type: "object"},message:"must be object"}];return false;}}validate20.errors = vErrors;return errors === 0;}