"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class MirrorLight extends _react["default"].Component {
  render() {
    const {
      inline,
      codeMirror,
      value,
      language,
      className,
      prefix,
      theme
    } = this.props;
    const elements = [];
    let index = 0;
    let lastStyle = null;
    let tokenBuf = '';

    const pushElement = (token, style) => {
      elements.push(_react["default"].createElement("span", {
        className: style ? prefix + style : '',
        key: ++index
      }, token));
    };

    const mode = codeMirror.findModeByName(language);
    codeMirror.runMode(value, mode ? mode.mime : language, (token, style) => {
      if (lastStyle === style) {
        tokenBuf += token;
        lastStyle = style;
      } else {
        if (tokenBuf) {
          pushElement(tokenBuf, lastStyle);
        }

        tokenBuf = token;
        lastStyle = style;
      }
    });
    pushElement(tokenBuf, lastStyle);

    const code = _react["default"].createElement("code", {
      className: inline ? `inline ${prefix}s-${theme}` : ''
    }, elements);

    return inline ? code : _react["default"].createElement("pre", {
      className: `${className} ${prefix}s-${theme}`
    }, code);
  }

}

exports["default"] = MirrorLight;

_defineProperty(MirrorLight, "propTypes", {
  codeMirror: _propTypes["default"].func.isRequired,
  className: _propTypes["default"].string,
  theme: _propTypes["default"].string,
  inline: _propTypes["default"].bool,
  language: _propTypes["default"].string,
  prefix: _propTypes["default"].string,
  value: _propTypes["default"].string.isRequired
});

_defineProperty(MirrorLight, "defaultProps", {
  className: '',
  prefix: 'cm-'
});

module.exports = exports["default"];